% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retentionIndexing.R
\name{correctRindex}
\alias{correctRindex}
\title{2-point correction of RIs}
\usage{
correctRindex(x, y)
}
\arguments{
\item{x}{\code{numeric} vector with retention indices, calculated by \code{indexRtime}}

\item{y}{\code{data.frame} containing two columns. The first is expected to
contain the measured RIs of the reference substances and the second the
reference RIs.}
}
\value{
\code{numeric} vector of same length than \code{x} with corrected retention
indices. Values are floating point decimals. If integer values shall be
used conversion has to be performed manually.
}
\description{
\code{correctRindex} performs correction of retention indices (RIs) based on
reference substances.
Even after conversion of RTs to RIs slight deviations might exist. These
deviations can be further normalized, if they are linear, by using two
metabolites for which the RIs are known (e.g. internal standards).
}
\examples{

ref <- data.frame(rindex = c(110, 210),
refindex = c(100, 200))
rindex <- c(110, 210)
correctRindex(rindex, ref)
}
\author{
Michael Witting
}
