% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lorenzCurve.R
\name{lorenzCurve}
\alias{lorenzCurve}
\title{Lorenz curve}
\usage{
lorenzCurve(samples, list)
}
\arguments{
\item{samples}{A character vector of sample names in list.}

\item{list}{A list data frames generated using the LymphoSeq function readImmunoSeq 
or productiveSeq.  "frequencyCount" is a required column.}
}
\value{
Returns a Lorenz curve.
}
\description{
Plots a Lorenz curve derived from the frequency of the amino acid sequences.
}
\details{
The Gini coefficient is an alternative metric used to calculate 
repertoire diversity and is derived from the Lorenz curve.  The Lorenz curve 
is drawn such that x-axis represents the cumulative percentage of unique 
sequences and the y-axis represents the cumulative percentage of reads.  A 
line passing through the origin with a slope of 1 reflects equal frequencies 
of all sequences.  The Gini coefficient is the ratio of the area between the 
line of equality and the observed Lorenz curve over the total area under the 
line of equality.

The plot is made using the package ggplot2 and can be reformatted
using ggplot2 functions.  See examples below.
}
\examples{
file.path <- system.file("extdata", "TCRB_sequencing", package = "LymphoSeq")

file.list <- readImmunoSeq(path = file.path)

lorenzCurve(samples = names(file.list), list = file.list)

productive.aa <- productiveSeq(file.list = file.list, aggregate = "aminoAcid")

lorenzCurve(samples = names(productive.aa), list = productive.aa)

# Change the legend labels, line colors, and add a title
samples <- c("TRB_Unsorted_0", "TRB_Unsorted_32", 
   "TRB_Unsorted_83", "TRB_Unsorted_949", "TRB_Unsorted_1320")

lorenz.curve <- lorenzCurve(samples = samples, list = productive.aa)

labels <- c("Day 0", "Day 32", "Day 83", "Day 949", "Day 1320")

colors <- c("navyblue", "red", "darkgreen", "orange", "purple")

lorenz.curve + ggplot2::scale_color_manual(name = "Samples", breaks = samples, 
   labels = labels, values = colors) + ggplot2::ggtitle("Figure Title")
}
\seealso{
An excellent resource for examples on how to reformat a ggplot can 
be found in the R Graphics Cookbook online (\url{http://www.cookbook-r.com/Graphs/}).
}
