% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloneTrack.R
\name{cloneTrack}
\alias{cloneTrack}
\title{Clone tracking plot}
\usage{
cloneTrack(sequence.matrix, map = "none", productive.aa, label = "none",
  track = "none", unassigned = TRUE)
}
\arguments{
\item{sequence.matrix}{A sequence matrix generated from the LymphoSeq 
function seqMatrix.}

\item{map}{An optional character vector of one or more sample names contained 
in the productive.aa list.  If the same sequence appears in multiple mapped 
samples, then it will be assigned the label of the first listed sample only.}

\item{productive.aa}{A list of data frames of productive amino acid sequences 
containing the samples to be mapped.  This parameter is only required if 
sequence mapping is performed.}

\item{label}{An optional character vector of one or more labels used to 
annotate the mapped sequences.  The order of the labels must match the order 
of the samples listed in map.}

\item{track}{An optional character vector of one or more amino acid sequences 
to track.}

\item{unassigned}{A Boolean value indicating whether or not to draw the lines 
of sequences not being mapped or tracked.  If TRUE then the unassigned 
sequences are drawn.  If FALSE, then the unassigned sequences are not drawn.}
}
\value{
Returns a line plot showing the amino acid frequencies across 
multiple samples in the sequence matrix where each line represents one 
unique sequence.
}
\description{
Creates line plot tracking amino acid frequencies across multiple samples
}
\details{
The plot is made using the package ggplot2 and can be reformatted
using ggplot2 functions.  See examples below.
}
\examples{
file.path <- system.file("extdata", "TCRB_sequencing", package = "LymphoSeq")

file.list <- readImmunoSeq(path = file.path)

productive.aa <- productiveSeq(file.list = file.list, aggregate = "aminoAcid")

top.freq <- topFreq(productive.aa = productive.aa, percent = 0.1)

sequence.matrix <- seqMatrix(productive.aa = productive.aa, sequences = top.freq$aminoAcid)

# Track clones without mapping or tracking specific sequences
cloneTrack(sequence.matrix = sequence.matrix)

# Track top 20 clones mapping to the CD4 and CD8 samples
cloneTrack(sequence.matrix = sequence.matrix, productive.aa = productive.aa, 
   map = c("TRB_CD4_949", "TRB_CD8_949"), label = c("CD4", "CD8"), 
   track = top.freq$aminoAcid[1:20], unassigned = TRUE) 

# Track the top 10 clones from top.freq
cloneTrack(sequence.matrix = sequence.matrix, productive.aa = productive.aa, 
   track = top.freq$aminoAcid[1:10], unassigned = FALSE) 

# Track clones mapping to the CD4 and CD8 samples while ignoring all others
cloneTrack(sequence.matrix = sequence.matrix, productive.aa = productive.aa, 
   map = c("TRB_CD4_949", "TRB_CD8_949"), label = c("CD4", "CD8"), 
   unassigned = FALSE) 

# Track clones mapping to the CD4 and CD8 samples and track 2 specific sequences
cloneTrack(sequence.matrix = sequence.matrix, productive.aa = productive.aa, 
   map = c("TRB_CD4_949", "TRB_CD8_949"), label = c("CD4", "CD8"), 
   track = c("CASSPPTGERDTQYF", "CASSQDRTGQYGYTF"), unassigned = FALSE)

# Reorder the x axis, change the axis labels, convert to log scale, and add title
x.limits <- c("TRB_Unsorted_0", "TRB_Unsorted_32", 
   "TRB_Unsorted_83", "TRB_Unsorted_949", "TRB_Unsorted_1320")

sequence.matrix <- sequence.matrix[ ,c("aminoAcid", x.limits)]
   
clone.track <- cloneTrack(sequence.matrix = sequence.matrix, 
   productive.aa = productive.aa, track = top.freq$aminoAcid[1:10], unassigned = FALSE) 

x.labels <- c("Day 0", "Day 32", "Day 83", "Day 949", "Day 1320")

clone.track + 
   ggplot2::scale_x_discrete(expand = c(0,0), labels = x.labels) + 
   ggplot2::scale_y_log10() + ggplot2::annotation_logticks(sides = "l") + 
   ggplot2::ggtitle("Figure Title")
}
\seealso{
An excellent resource for examples on how to reformat a ggplot can 
be found in the R Graphics Cookbook online (\url{http://www.cookbook-r.com/Graphs/}).
}
