% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SanityChecK.R
\name{SanityChecK}
\alias{SanityChecK}
\title{Sanity Check for Input Data and Parameters}
\usage{
SanityChecK(
  x,
  niter = 1000,
  K = NULL,
  meta.info,
  group.name,
  formula.str,
  verbose = TRUE,
  log = TRUE
)
}
\arguments{
\item{x}{A matrix-like object or a \code{SummarizedExperiment} containing the
data to be analyzed.}

\item{niter}{Integer. Number of bootstrap samples or resampling iterations.
Default is 1000.}

\item{K}{Integer. Top list size. If NULL, it will be set to a quarter of
the number of rows in the data matrix. Default is NULL.}

\item{meta.info}{Data frame. Metadata associated with the samples
(columns of \code{data.exp}). If \code{data.exp} is a \code{SummarizedExperiment},
\code{meta.info} can be a vector of \code{colData} column names to use.}

\item{group.name}{Character. Column name in \code{meta.info} that defines the
groups or conditions for comparison.}

\item{formula.str}{Optional character string representing the formula for
the model.}

\item{verbose}{Logical, indicating whether to display messages during the
function's execution. Default is TRUE.}

\item{log}{Logical, indicating whether the data is already log-transformed.
Default is TRUE.}
}
\value{
A list containing:
\itemize{
\item \code{meta.info}: Processed metadata.
\item \code{data}: Processed data matrix.
\item \code{groups}: Numeric or factor vector indicating group assignments.
\item \code{K}: Top list size to be used in the analysis.
}
}
\description{
This function performs a series of checks and initial setups for input data,
metadata, and parameters, ensuring everything is correctly formatted for
downstream analysis.
}
\details{
This function checks whether the input data and metadata are in the correct
format, processes metadata from a \code{SummarizedExperiment} object if provided,
and ensures that group information is correctly specified. If no top list
size (\code{K}) is provided, it defaults to a quarter of the number of rows in
the data.
}
