% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postEnrichment.R
\name{writeCombinedEnrichment}
\alias{writeCombinedEnrichment}
\title{Function for writing output all at once: combinedResults is an table
generated by "locationEnrichment()" or by rbinding category/location results.
Writes all enrichments to a single file, and also spits out the same data
divided into groups based on userSets, and Databases, just for convenience.
disable this with an option.}
\usage{
writeCombinedEnrichment(
  combinedResults,
  outFolder = NULL,
  includeSplits = TRUE
)
}
\arguments{
\item{combinedResults}{enrichment results object}

\item{outFolder}{location to write results on disk}

\item{includeSplits}{also include individual files for each user set and database?}
}
\value{
No return value.
}
\description{
Function for writing output all at once: combinedResults is an table
generated by "locationEnrichment()" or by rbinding category/location results.
Writes all enrichments to a single file, and also spits out the same data
divided into groups based on userSets, and Databases, just for convenience.
disable this with an option.
}
\examples{
dbPath = system.file("extdata", "hg19", package="LOLA")
regionDB = loadRegionDB(dbLocation=dbPath)
data("sample_universe", package="LOLA")
data("sample_input", package="LOLA")

getRegionSet(regionDB, collections="ucsc_example", filenames="vistaEnhancers.bed")
getRegionSet(dbPath, collections="ucsc_example", filenames="vistaEnhancers.bed")
getRegionFile(dbPath, collections="ucsc_example", filenames="vistaEnhancers.bed")


res = runLOLA(userSets, userUniverse, regionDB, cores=1)
locResult = res[2,]
extractEnrichmentOverlaps(locResult, userSets, regionDB)
writeCombinedEnrichment(locResult, "temp_outfolder")

userSetsRedefined =	redefineUserSets(userSets, userUniverse)
resRedefined = runLOLA(userSetsRedefined, userUniverse, regionDB, cores=1)

g = plotTopLOLAEnrichments(resRedefined)

}
