% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadRegionDB.R
\name{readCollectionFiles}
\alias{readCollectionFiles}
\title{Given a database and a collection, this will create the region annotation
data.table; either giving a generic table based on file names, or by
reading in the annotation data.}
\usage{
readCollectionFiles(dbLocation, collection, refreshSizes = FALSE)
}
\arguments{
\item{dbLocation}{folder where your regionDB is stored.}

\item{collection}{Collection folder to load}

\item{refreshSizes}{should I recreate the sizes files
documenting how many regions (lines) are in each region set?}
}
\value{
A data.table annotating the regions in the collections.
}
\description{
Given a database and a collection, this will create the region annotation
data.table; either giving a generic table based on file names, or by
reading in the annotation data.
}
\examples{
dbPath = system.file("extdata", "hg19", package="LOLA")
regionAnno = readCollectionFiles(dbLocation=dbPath, "ucsc_example")
}
