% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-functions.R
\name{reset_mandatory_IS_vars}
\alias{reset_mandatory_IS_vars}
\alias{vars_resetters}
\alias{reset_annotation_IS_vars}
\alias{reset_af_columns_def}
\alias{reset_iss_stats_specs}
\alias{reset_matrix_file_suffixes}
\alias{reset_dyn_vars_config}
\title{Resets dynamic vars to the default values.}
\usage{
reset_mandatory_IS_vars()

reset_annotation_IS_vars()

reset_af_columns_def()

reset_iss_stats_specs()

reset_matrix_file_suffixes()

reset_dyn_vars_config()
}
\value{
\code{NULL}
}
\description{
Reverts all changes to dynamic vars to the default values.
For more details, refer to the dedicated vignette
\code{vignette("workflow_start", package="ISAnalytics")}.
\itemize{
\item \code{reset_mandatory_IS_vars()} re-sets the look-up table for
mandatory IS vars.
}

\itemize{
\item \code{reset_annotation_IS_vars()} re-sets the look-up table for
genomic annotation IS vars.
}

\itemize{
\item \code{reset_af_columns_def()} re-sets the look-up table for
association file columns vars
}

\itemize{
\item \code{reset_iss_stats_specs()} re-sets the look-up table for VISPA2 pool
statistics vars
}

\itemize{
\item \code{reset_matrix_file_suffixes()} re-sets the matrix file suffixes look-up
table
}

\itemize{
\item \code{reset_dyn_vars_config()} re-sets all look-up tables
}
}
\examples{
reset_mandatory_IS_vars()

reset_annotation_IS_vars()

reset_af_columns_def()

reset_iss_stats_specs()

reset_matrix_file_suffixes()

reset_dyn_vars_config()
}
\seealso{
Other dynamic vars: 
\code{\link{inspect_tags}()},
\code{\link{mandatory_IS_vars}()},
\code{\link{pcr_id_column}()},
\code{\link{set_mandatory_IS_vars}()},
\code{\link{set_matrix_file_suffixes}()}
}
\concept{dynamic vars}
