% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population-size-estimate.R
\name{HSC_population_size_estimate}
\alias{HSC_population_size_estimate}
\title{Hematopoietic stem cells population size estimate.}
\usage{
HSC_population_size_estimate(
  x,
  metadata,
  stable_timepoints = NULL,
  aggregation_key = c("SubjectID", "CellMarker", "Tissue", "TimePoint"),
  blood_lineages = blood_lineages_default(),
  timepoint_column = "TimePoint",
  seqCount_column = "seqCount_sum",
  fragmentEstimate_column = "fragmentEstimate_sum",
  seqCount_threshold = 3,
  fragmentEstimate_threshold = 3,
  nIS_threshold = 5,
  cell_type = "MYELOID",
  tissue_type = "PB",
  max_workers = 4
)
}
\arguments{
\item{x}{An aggregated integration matrix. See details.}

\item{metadata}{An aggregated association file. See details.}

\item{stable_timepoints}{A numeric vector or NULL if there are no
stable time points. NOTE: the vector is NOT intended as a sequence min-max,
every stable time point has to be specified individually}

\item{aggregation_key}{A character vector indicating the key used for
aggregating x and metadata. Note that x and metadata should always be
aggregated with the same key.}

\item{blood_lineages}{A data frame containing information on the blood
lineages. Users can supply their own, provided the columns \code{CellMarker} and
\code{CellType} are present.}

\item{timepoint_column}{What is the name of the time point column to use?
Note that this column must be present in the key.}

\item{seqCount_column}{What is the name of the column in x containing the
values of sequence count quantification?}

\item{fragmentEstimate_column}{What is the name of the column in x
containing the values of fragment estimate quantification? If fragment
estimate is not present in the matrix, param should be set to \code{NULL}.}

\item{seqCount_threshold}{A single numeric value. After re-aggregating \code{x},
rows with a value greater or equal will be kept, the others will be
discarded.}

\item{fragmentEstimate_threshold}{A single numeric value. Threshold
value for fragment estimate, see details.}

\item{nIS_threshold}{A single numeric value. If a group (row) in the
metadata data frame has a count of distinct integration sites strictly
greater than this number it will be kept, otherwise discarded.}

\item{cell_type}{The cell types to include in the models. Note that
the matching is case-insensitive.}

\item{tissue_type}{The tissue types to include in the models. Note that
the matching is case-insensitive.}

\item{max_workers}{Maximum parallel workers allowed}
}
\value{
A data frame with the results of the estimates
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Hematopoietic stem cells population size estimate with capture-recapture
models.
}
\section{Input formats}{
Both \code{x} and \code{metadata} should be supplied to the function in aggregated
format (ideally through the use of \code{\link{aggregate_metadata}}
and \code{\link{aggregate_values_by_key}}).
Note that the \code{aggregation_key}, aka the vector of column names used for
aggregation, must contain at least the columns associated with the tags
\code{subject}, \code{cell_marker}, \code{tissue} and a time point column
(the user can specify the name of the
column in the argument \code{timepoint_column}).
}

\section{Specifying more than one group}{
Groups for the estimates are computed as a pair of cell type and tissue.
If the user wishes to compute estimates for more than one combination
of cell type and tissue, it is possible to specify them as character
vectors to the fields \code{cell_type} and \code{tissue_type} respectively,
noting that:
\itemize{
\item Vectors must have the same length or one of the 2 has to be of length 1
\item It is a responsibility of the user to check whether the combination
exists in the dataset provided.
}

Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{estimate <- HSC_population_size_estimate(
    x = aggreg,
    metadata = aggreg_meta,
    cell_type = c("MYELOID", "T", "B"),
    tissue_type = "PB"
)

# Evaluated groups will be:
# - MYELOID PB
# - T PB
# - B PB
}\if{html}{\out{</div>}}

Note that estimates are computed individually for each group.
}

\section{On time points}{
If \code{stable_timepoints} is a vector with length > 1, the function will look
for the first available stable time point and slice the data from that
time point onward. If \code{NULL} is supplied instead, it means there are no
stable time points available. Note that 0 time points are ALWAYS discarded.
Also, to be included in the analysis, a group must have at least 2
distinct non-zero time points.
NOTE: the vector passed has to contain all individual time points, not
just the minimum and maximum
}

\section{Setting a threshold for fragment estimate}{
If fragment estimate is present in the input matrix, the filtering logic
changes slightly: rows in the original matrix are kept if the sequence
count value is greater or equal than the \code{seqCount_threshold} AND
the fragment estimate value is greater or equal to the
\code{fragmentEstimate_threshold} IF PRESENT (non-zero value).
This means that for rows that miss fragment estimate, the filtering logic
will be applied only on sequence count. If the user wishes not to use
the combined filtering with fragment estimate, simply set
\code{fragmentEstimate_threshold = 0}.
}

\section{Required tags}{

The function will explicitly check for the presence of these tags:
\itemize{
\item subject
\item tissue
\item cell_marker
}
}

\examples{
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
aggreg <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    value_cols = c("seqCount", "fragmentEstimate")
)
aggreg_meta <- aggregate_metadata(association_file = association_file)
estimate <- HSC_population_size_estimate(
    x = aggreg,
    metadata = aggreg_meta,
    fragmentEstimate_column = NULL,
    stable_timepoints = c(90, 180, 360),
    cell_type = "Other"
)
}
\seealso{
Other Analysis functions: 
\code{\link{CIS_grubbs}()},
\code{\link{compute_abundance}()},
\code{\link{cumulative_is}()},
\code{\link{gene_frequency_fisher}()},
\code{\link{is_sharing}()},
\code{\link{iss_source}()},
\code{\link{sample_statistics}()},
\code{\link{top_integrations}()},
\code{\link{top_targeted_genes}()}
}
\concept{Analysis functions}
