% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_start_end_with_random.R
\name{plot_start_end_with_random}
\alias{plot_start_end_with_random}
\title{Plot signals around the start and the end of genomic features and
random regions}
\usage{
plot_start_end_with_random(
  queryFiles,
  inputFiles = NULL,
  txdb = NULL,
  centerFile,
  importParams = NULL,
  binSize = 10,
  insert = 0,
  verbose = FALSE,
  ext = c(-500, 200, -200, 500),
  hl = c(-50, 50, -50, 50),
  randomize = FALSE,
  stranded = TRUE,
  scale = FALSE,
  smooth = FALSE,
  rmOutlier = 0,
  outPrefix = NULL,
  transform = NA,
  shade = TRUE,
  nc = 2,
  hw = c(8, 8),
  Ylab = "Coverage/base/gene"
)
}
\arguments{
\item{queryFiles}{a vector of sample file names. The file should be in .bam,
.bed, .wig or .bw format, mixture of formats is allowed}

\item{inputFiles}{a vector of input sample file names. The file should be in
.bam, .bed, .wig or .bw format, mixture of formats is allowed}

\item{txdb}{a TxDb object defined in the GenomicFeatures package. Default
NULL, needed only when genomic features are used in the place of centerFile.}

\item{centerFile}{a bed file that defines the custom feature, or a feature
in c("utr3", "utr5", "cds", "intron", "exon", "transcript", "gene"),
multiple features are not allowed.}

\item{importParams}{a list of parameters for \code{handle_input}}

\item{binSize}{an integer defines bin size for intensity calculation}

\item{insert}{an integer specifies the length of the center regions to be
included, in addition to the start and end of the feature}

\item{verbose}{logical, whether to output additional information
(data used for plotting or statistical test results)}

\item{ext}{a vector of four integers defining upstream and downstream
boundaries of the plot window, flanking the start and end of features}

\item{hl}{a vector of four integers defining upstream and downstream
boundaries of the highlight window, flanking the start and end of features}

\item{randomize}{logical, indicating if randomized feature should generated
and used as a contrast to the real feature. The ransomized feature is
generated by shifting the given feature with a random offset within the
range of ext[1] and ext[4]}

\item{stranded}{logical, indicating whether the strand of the feature s
hould be considered}

\item{scale}{logical, indicating whether the score matrix should be scaled to
the range 0:1, so that samples with different baseline can be compared}

\item{smooth}{logical, indicating whether the line should smoothed with a
spline smoothing algorithm}

\item{rmOutlier}{a numeric value serving as a multiplier of the MAD in Hampel
filter for outliers identification, 0 indicating not removing outliers. For
Gaussian distribution, use 3, adjust based on data distribution}

\item{outPrefix}{a string specifying output file prefix for plots
(outPrefix.pdf)}

\item{transform}{a string in c("log", "log2", "log10"), default = NA
indicating no transformation of data matrix}

\item{shade}{logical indicating whether to place a shaded rectangle around
the point of interest}

\item{nc}{integer, number of cores for parallel processing}

\item{hw}{a vector of two elements specifying the height and width of the
output figures}

\item{Ylab}{a string for y-axis label}
}
\value{
a list of two objects, the first is a GRanges object, the second is
a GRangesList object
}
\description{
Plot reads or peak Coverage/base/gene of samples given in the
query files around start, end and center of genomic features or custom feature
given in a .bed file. The upstream and downstream windows can be given
separately. If Input files are provided, ratio over Input is computed and
displayed as well. A random feature can be generated to serve as a background
for contrasting.
}
\examples{

gtfFile <- system.file("extdata", "gencode.v19.annotation_chr19.gtf",
    package = "GenomicPlot"
)

txdb <- custom_TxDb_from_GTF(gtfFile, genome = "hg19")

bamQueryFiles <- system.file("extdata", "treat_chr19.bam",
                             package = "GenomicPlot")
names(bamQueryFiles) <- "clip_bam"
bamInputFiles <- system.file("extdata", "input_chr19.bam",
                             package = "GenomicPlot")
names(bamInputFiles) <- "clip_input"

bamImportParams <- setImportParams(
  offset = -1, fix_width = 0, fix_point = "start", norm = TRUE,
  useScore = FALSE, outRle = TRUE, useSizeFactor = FALSE, genome = "hg19"
)

plot_start_end_with_random(
  queryFiles = bamQueryFiles,
  inputFiles = bamInputFiles,
  txdb = txdb,
  centerFile = "intron",
  binSize = 10,
  importParams = bamImportParams,
  ext = c(-100, 100, -100, 100),
  hl = c(-20, 20, -20, 20),
  insert = 100,
  stranded = TRUE,
  scale = FALSE,
  smooth = TRUE,
  verbose = TRUE,
  transform = "log2",
  outPrefix = NULL,
  randomize = TRUE,
  nc = 2
)

}
\author{
Shuye Pu
}
