% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenomicPlot.R
\name{plot_named_list}
\alias{plot_named_list}
\title{plot a named list as a figure}
\usage{
plot_named_list(params)
}
\arguments{
\item{params}{a list produced by as.list(environment()), with names being the
arguments and values being the runtime values when the function is called.}
}
\value{
a ggplot object
}
\description{
This is a helper function for displaying function arguments for
a plotting function. If the runtime value of the argument is a small object,
its values is displayed, otherwise, only the name of the value of the
argument is displayed.
}
\examples{

data(gf5_genomic)

gtfFile <- system.file("extdata", "gencode.v19.annotation_chr19.gtf",
    package = "GenomicPlot"
)

txdb <- custom_TxDb_from_GTF(gtfFile, genome = "hg19")

queryfiles <- system.file("extdata", "treat_chr19.bam",
    package = "GenomicPlot"
)
names(queryfiles) <- "query"

inputfiles <- system.file("extdata", "input_chr19.bam",
    package = "GenomicPlot"
)
names(inputfiles) <- "input"

bamimportParams <- setImportParams(
    offset = -1, fix_width = 0, fix_point = "start", norm = TRUE,
    useScore = FALSE, outRle = TRUE, useSizeFactor = FALSE, genome = "hg19"
)

alist <- list(
    "txdb" = txdb, "treat" = queryfiles, "control" = inputfiles,
    "feature" = gf5_genomic, "param" = bamimportParams
)

GenomicPlot:::plot_named_list(alist)

}
\author{
Shuye Pu
}
\keyword{internal}
