% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawingFunctions.R
\name{draw_region_landmark}
\alias{draw_region_landmark}
\title{Plot genomic region landmark indicator}
\usage{
draw_region_landmark(featureNames, vx, xmax)
}
\arguments{
\item{featureNames}{a string vector giving names of sub-regions}

\item{vx}{a vector on integers denoting the x coordinates of start of each
sub-region}

\item{xmax}{an integer denoting the left most boundary}
}
\value{
a ggplot object
}
\description{
Plot a gene centered polygon for demarcating gene and its
upstream and downstream regions
}
\note{
used by \code{\link{plot_5parts_metagene}}, \code{\link{plot_region}}
}
\examples{
fn <- c("5'UTR", "CDS", "3'UTR")
mark <- c(1, 5, 20)
xmax <- 25

p <- draw_region_landmark(featureNames = fn, vx = mark, xmax = xmax)

}
\author{
Shuye Pu
}
