% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawingFunctions.R
\name{draw_boxplot_by_factor}
\alias{draw_boxplot_by_factor}
\title{Plot boxplot with two factors}
\usage{
draw_boxplot_by_factor(
  stat_df,
  xc = "Feature",
  yc = "Intensity",
  fc = "",
  comp = list(c(1, 2)),
  stats = "wilcox.test",
  Xlab = xc,
  Ylab = yc,
  nf = 1
)
}
\arguments{
\item{stat_df}{a dataframe with column names c(xc, yc)}

\item{xc}{a string denoting column name for grouping}

\item{yc}{a string denoting column name for numeric data to be plotted}

\item{fc}{a string denoting column name for sub-grouping based on an
additional factor}

\item{comp}{a list of vectors denoting pair-wise comparisons to be performed
between groups}

\item{stats}{the name of pair-wise statistical tests, like t.test or
wilcox.test}

\item{Xlab}{a string for x-axis label}

\item{Ylab}{a string for y-axis label}

\item{nf}{a integer normalizing factor for correct count of observations when
the data table has two factors, such as those produced by `pivot_longer`,
equals to the number of factors (values can only be 1 or 2)}
}
\value{
a ggplot object
}
\description{
Plot violin plot with boxplot components for data with one or
two factors, p-value significance levels are displayed, "***" = 0.001,
"**" = 0.01, "*" = 0.05.
}
\note{
used by \code{\link{plot_locus}}, \code{\link{plot_locus_with_random}},
   \code{\link{plot_region}}
}
\examples{
stat_df <- data.frame(
    Feature = rep(c("A", "B", "A", "B"), c(15, 15, 15, 15)),
    Covar = rep(c("treat", "control", "dummy"), c(20, 20, 20)),
    Intensity = c(rnorm(30, 2, 0.5), rnorm(30, 3, 0.6))
)
p <- draw_boxplot_by_factor(stat_df,
    fc = "Feature", yc = "Intensity",
    xc = "Covar", Ylab = "Signal Intensity",
    comp = list(c(1, 2), c(3, 4), c(5, 6)),
    nf = 2
)
p
}
\author{
Shuye Pu
}
