% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk_transfer.R
\name{transfer}
\alias{transfer}
\alias{gdc_client_version_validate}
\alias{transfer_help}
\title{Bulk data download}
\usage{
transfer(uuids, args = character(), token = NULL, overwrite = FALSE)

gdc_client_version_validate(valid_version = .GDC_COMPATIBLE_VERSION)

transfer_help()
}
\arguments{
\item{uuids}{character() vector of GDC file UUIDs}

\item{args}{character() vector specifying command-line arguments to
be passed to \code{gdc-client}. See \code{\link{transfer_help}} for
possible values. The arguments \code{--manifest}, \code{--dir},
and \code{--token-file} are determined by \code{manifest},
\code{destination_dir}, and \code{token}, respectively, and
should NOT be provided as elements of \code{args}.}

\item{token}{character(1) containing security
token allowing access to restricted data. See
\url{https://gdc-docs.nci.nih.gov/API/Users_Guide/Authentication_and_Authorization/}.
Note that the GDC transfer tool requires a file for data
transfer. Therefore, this token will be written to a temporary
file (with appropriate permissions set).}

\item{overwrite}{logical(1) default FALSE indicating whether
existing files with identical name should be over-written.}

\item{valid_version}{character(1) The last known version that works for the
current data release for which to validate against, not typically changed
by the end-user.}
}
\value{
character(1) directory path to which the files were
    downloaded.
}
\description{
The GDC maintains a special tool,
\href{the GDC Data Transfer Tool}{https://docs.gdc.cancer.gov/Data_Transfer_Tool/Users_Guide/Getting_Started/},
that enables high-performance, potentially parallel, and
resumable downloads. The Data Transfer Tool is an external
program that requires separate download. Due to recent changes in the
GDC API, the transfer function now validates the version of the `gdc-client`
to ensure reliable downloads.
}
\section{Functions}{
\itemize{
\item \code{gdc_client_version_validate()}: If you are using the 'client' option, your `gdc-client` should be
up-to-date (>= 1.3.0).

\item \code{transfer_help()}: 

}}
\examples{
\dontrun{
uuids = files() |> 
  filter(access == "open") |> 
  results() |>
  ids()
file_paths <- transfer(uuids)
file_paths
names(file_paths)
# and with authenication
# REQUIRES gdc_token 
# destination <- transfer(uuids,token=gdc_token())
}

}
