% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand}
\alias{expand}
\alias{expand.GDCQuery}
\title{Set the \code{expand} parameter}
\usage{
expand(x, expand)

\method{expand}{GDCQuery}(x, expand)
}
\arguments{
\item{x}{the objects on which to set fields}

\item{expand}{a character vector specifying the fields}
}
\value{
A \code{\link{GDCQuery}} object, with the \code{expand}
member altered.
}
\description{
S3 generic to set GDCQuery expand parameter
}
\section{Methods (by class)}{
\itemize{
\item \code{expand(GDCQuery)}: set expand fields on a GDCQuery object

}}
\examples{
gProj = projects()
gProj$fields
head(available_fields(gProj))
default_fields(gProj)

gProj |>
  select(default_fields(gProj)[1:2]) |>
  response() |>
  str(max_level=2)

}
