% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entity_name.R
\name{entity_name}
\alias{entity_name}
\alias{entity_name.GDCQuery}
\alias{entity_name.GDCResults}
\title{Get the entity name from a GDCQuery object}
\usage{
entity_name(x)

\method{entity_name}{GDCQuery}(x)

\method{entity_name}{GDCResults}(x)
}
\arguments{
\item{x}{a \code{\link{GDCQuery}} object}
}
\value{
character(1) name of an associated entity; one of
"cases", "files", "projects", "annotations".
}
\description{
An "entity" is simply one of the four medata endpoints.
\itemize{
\item{cases}
\item{projects}
\item{files}
\item{annotations}
}
All \code{\link{GDCQuery}} objects will have an entity name. This S3 method
is simply a utility accessor for those names.
}
\examples{
qcases = cases()
qprojects = projects()

entity_name(qcases)
entity_name(qprojects)

}
