% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsvaNewAPI.R
\name{guessGeneIdType}
\alias{guessGeneIdType}
\title{Guess the gene identifier type from a list of character vectors}
\usage{
guessGeneIdType(geneIdsList)
}
\arguments{
\item{geneIdsList}{A named list of character vectors like the ones returned
by \code{geneIds()}.}
}
\value{
An object of a subclass of \code{GeneIdentifierType} derived from the
input.
}
\description{
This function tries to derive the type of gene IDs used in a
named list of \code{character} vectors provided as input.
}
\details{
In order to make this function useful and keep it as simple as
possible, we limit ourselves to the most common types of gene identifiers:
"Gene IDs" consisting of digits only are considered ENTREZ IDs, anything
starting with 'ENS' an ENSEMBL identifier and anything else a HuGO gene
symbol.
}
\seealso{
\code{\link[GSEABase:GeneIdentifierType-class]{GeneIdentifierType}}
}
