% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdcClinical.R
\name{gdcClinicalMerge}
\alias{gdcClinicalMerge}
\title{Merge clinical data}
\usage{
gdcClinicalMerge(path, key.info = TRUE, organized = FALSE)
}
\arguments{
\item{path}{path to downloaded files for merging}

\item{key.info}{logical, whether to return the key clinical 
information only. If \code{TRUE}, only clinical information 
such as age, stage, grade, overall survial, etc. will be returned}

\item{organized}{logical, whether the clinical data have already
been organized into a single folder (eg., data downloaded by the
'GenomicDataCommons' method are already organized). 
Default is \code{FALSE}.}
}
\value{
A dataframe of clinical data with rows are patients 
    and columns are clinical traits
}
\description{
Merge clinical data in \code{.xml} files 
    that are downloaded from GDC to a dataframe
}
\examples{
####### Merge clinical data #######
path <- 'Clinical/'
\dontrun{clinicalDa <- gdcClinicalMerge(path=path, key.info=TRUE)}
}
\author{
Ruidong Li and Han Qu
}
