% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{nmar}
\alias{nmar}
\alias{nmar,GbsrGenotypeData-method}
\title{Return the number of SNPs.}
\usage{
nmar(object, valid = TRUE, chr = NULL, ...)

\S4method{nmar}{GbsrGenotypeData}(object, valid, chr)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{valid}{A logical value. See details.}

\item{chr}{A index to spefcify chromosome to get information.}

\item{...}{Unused.}
}
\value{
An integer value to indicate the number of SNP markers.
}
\description{
This function returns the number of SNPs recorded in the GDS file
connected to the given \link{GbsrGenotypeData} object.
}
\details{
If \code{valid = TRUE}, the number of markers which are labeled \code{TRUE} in the
"valid" column of the "marker" slot will be returned. If you need the number
of over all markers, set \code{valid = FALSE}. \code{\link[=validMar]{validMar()}} tells you
which markers are valid.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

nmar(gds)

# Close the connection to the GDS file.
closeGDS(gds)

}
\seealso{
\code{\link[=validMar]{validMar()}}
}
