% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_annotate_plots.R
\name{sc_impute_transcript}
\alias{sc_impute_transcript}
\title{Impute missing transcript counts}
\usage{
sc_impute_transcript(combined_sce, dimred = "PCA", ...)
}
\arguments{
\item{combined_sce}{A \code{SingleCellExperiment} object with gene counts and a "transcript" altExp slot.}

\item{dimred}{The name of the reduced dimension to use for building the shared nearest neighbor graph.}

\item{...}{Additional arguments to pass to \code{scran::buildSNNGraph}. E.g. \code{k = 30}.}
}
\value{
A \code{SingleCellExperiment} object with imputed logcounts assay in the "transcript" altExp slot.
}
\description{
Impute missing transcript counts using a shared nearest neighbor graph
}
\details{
For cells with \code{NA} values in the "transcript" altExp slot, this function imputes the
missing values from cells with non-missing values. A shared nearest neighbor graph is built using
reduced dimensions from the \code{SingleCellExperiment} object, and the imputation is done where
the imputed value for a cell is the weighted sum of the transcript counts of its neighbors.
Imputed values are stored in the "logcounts" assay of the "transcript" altExp slot.
The "counts" assay is used to obtain logcounts but left unchanged.
}
\examples{
sce <- SingleCellExperiment::SingleCellExperiment(assays = list(counts = matrix(rpois(50, 5), ncol = 10)))
long_read <- SingleCellExperiment::SingleCellExperiment(assays = list(counts = matrix(rpois(40, 5), ncol = 10)))
SingleCellExperiment::altExp(sce, "transcript") <- long_read
SingleCellExperiment::counts(SingleCellExperiment::altExp(sce))[,1:2] <- NA
SingleCellExperiment::counts(SingleCellExperiment::altExp(sce))
imputed_sce <- sc_impute_transcript(sce, k = 4)
SingleCellExperiment::logcounts(SingleCellExperiment::altExp(imputed_sce))

}
