% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-BulkPipeline.R
\name{index_genome}
\alias{index_genome}
\alias{index_genome,FLAMES.Pipeline-method}
\title{Index the reference genome for minimap2}
\usage{
index_genome(pipeline, path, additional_args = c("-k", "14"))

\S4method{index_genome}{FLAMES.Pipeline}(pipeline, path, additional_args = c("-k", "14"))
}
\arguments{
\item{pipeline}{A FLAMES.Pipeline object.}

\item{path}{The file path to save the minimap2 index. If not provided, it will be saved
to the output directory with the name "genome.mmi".}

\item{additional_args}{(optional) Additional arguments to pass to minimap2.}
}
\value{
A \code{SummarizedExperiment} object, a \code{SingleCellExperiment} object,
or a list of \code{SingleCellExperiment} objects.
}
\description{
Calls minimap2 to index the reference genome.
}
\examples{
pipeline <- example_pipeline(type = "BulkPipeline")
pipeline <- index_genome(pipeline)
}
