% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-BulkPipeline.R
\name{controllers<-}
\alias{controllers<-}
\alias{controllers<-,FLAMES.Pipeline-method}
\title{Set controllers}
\usage{
controllers(pipeline) <- value

\S4method{controllers}{FLAMES.Pipeline}(pipeline) <- value
}
\arguments{
\item{pipeline}{A FLAMES.Pipeline object.}

\item{value}{A \code{crew_class_controller} object or a named list of
\code{crew_class_controller} objects. If a single controller is provided,
it will be used for all steps in the pipeline. If a named list is provided,
steps with names that match the names of the list will use the corresponding
controller, and steps without a specified controller will use the current R
session.}
}
\value{
An updated FLAMES.Pipeline object with the specified controllers.
}
\description{
Sets the controllers for the pipeline.
}
\examples{
pipeline <- example_pipeline()
# Only set the genome alignment controller
controllers(pipeline) <- list(genome_alignment = crew::crew_controller_local())
# Same as above
controllers(pipeline)[["genome_alignment"]] <- crew::crew_controller_local()
# Set a controller for all steps
controllers(pipeline) <- crew::crew_controller_local()
# Unset all controllers and use the current R session
controllers(pipeline) <- list()
}
