% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-BulkPipeline.R
\name{run_step}
\alias{run_step}
\alias{run_step,FLAMES.Pipeline-method}
\title{Execute a single step of the FLAMES pipeline}
\usage{
run_step(pipeline, step, disable_controller = TRUE)

\S4method{run_step}{FLAMES.Pipeline}(pipeline, step, disable_controller = TRUE)
}
\arguments{
\item{pipeline}{A FLAMES.Pipeline object.}

\item{step}{The step to run. One of "barcode_demultiplex", "genome_alignment",
 "gene_quantification", "isoform_identification", "read_realignment", or
"transcript_quantification".}

\item{disable_controller}{(optional) If TRUE, the step will be executed in
the current R session, instead of using crew controllers.}
}
\value{
An updated FLAMES.Pipeline object.
}
\description{
This function runs the specified step of the FLAMES pipeline.
}
\examples{
pipeline <- example_pipeline("BulkPipeline")
pipeline <- run_step(pipeline, "genome_alignment")

}
\seealso{
\code{\link{run_FLAMES}} to run the entire pipeline.
\code{\link{resume_FLAMES}} to resume a pipeline from the last completed step.
}
