% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_annotate_plots.R
\name{plot_isoform_heatmap}
\alias{plot_isoform_heatmap}
\title{FLAMES heetmap plots}
\usage{
plot_isoform_heatmap(
  sce,
  gene_id,
  transcript_ids,
  n = 4,
  isoform_legend_width = 7,
  col_low = "#313695",
  col_mid = "#FFFFBF",
  col_high = "#A50026",
  color_quantile = 1,
  cluster_palette,
  ...
)
}
\arguments{
\item{sce}{The \code{SingleCellExperiment} object containing transcript counts,
\code{rowRanges} and \code{rowData} with \code{gene_id} and \code{transcript_id} columns.}

\item{gene_id}{The gene symbol of interest, ignored if \code{transcript_ids} is provided.}

\item{transcript_ids}{The transcript ids to plot.}

\item{n}{The number of top isoforms to plot from the gene. Ignored if \code{transcript_ids} is provided.}

\item{isoform_legend_width}{The width of isoform legends in heatmaps, in \code{cm}.}

\item{col_low}{Color for cells with low expression levels in UMAPs.}

\item{col_mid}{Color for cells with intermediate expression levels in UMAPs.}

\item{col_high}{Color for cells with high expression levels in UMAPs.}

\item{color_quantile}{The lower and upper expression quantile to be displayed bewteen \code{col_low} and \code{col_high}, e.g. with \code{color_quantile = 0.95}, cells with expressions higher than 95\% of other cells will all be shown in \code{col_high}, and cells with expression lower than 95\% of other cells will all be shown in \code{col_low}.}

\item{cluster_palette}{Optional, named vector of colors for the cluster annotations.}

\item{...}{Additional arguments to pass to \code{\link[ComplexHeatmap]{Heatmap}}.}
}
\value{
a \code{ComplexHeatmap}
}
\description{
Plot expression heatmap of top n isoforms of a gene
}
\details{
Takes \code{SingleCellExperiment} object and plots an expression heatmap with the
isoform visualizations along genomic coordinates.
}
\examples{
data(scmixology_lib10_transcripts)
scmixology_lib10_transcripts |>
  scuttle::logNormCounts() |>
  plot_isoform_heatmap(gene = "ENSG00000108107")

}
