% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_spikein_clade.R
\name{validate_spikein_clade}
\alias{validate_spikein_clade}
\title{Validate Spike-In Clade Consistency with NJ Tree and Bootstrap}
\usage{
validate_spikein_clade(
  reference_fasta,
  sample_fasta,
  bootstrap = 100,
  output_prefix = NULL
)
}
\arguments{
\item{reference_fasta}{Character. Path to FASTA file of reference spike-ins.}

\item{sample_fasta}{Character. Path to FASTA file of sample spike-ins.}

\item{bootstrap}{Integer. Number of bootstrap replicates (default = 100).}

\item{output_prefix}{Character or NULL. File prefix for saving output.}
}
\value{
A list with:
\describe{
\item{tree}{NJ tree (class \code{phylo})}
\item{monophyly}{TRUE if sample spike-ins form a clade}
\item{clade_bootstrap}{Bootstrap support percentage}
\item{branch_stats}{Branch length summary}
\item{patristic_distances}{Patristic distance matrix}
\item{tree_plot}{Tree plot object}
\item{branch_boxplot}{Boxplot object}
\item{patristic_histogram}{Histogram object}
\item{summary_text}{Text summary}
\item{alignment}{Multiple sequence alignment (MSA)}
\item{aln_phydat}{Alignment converted to \code{phyDat}}
\item{distance_matrix}{JC69 distance matrix}
}
}
\description{
Validates whether sample spike-in sequences form a monophyletic clade
with known reference spike-in(s) using a Neighbor-Joining (NJ) tree
with Jukes-Cantor correction and bootstrap support.

This function produces:
\itemize{
\item A bootstrap-annotated NJ tree
\item A boxplot comparing branch lengths
\item A histogram of patristic distances
}
If \code{output_prefix} is provided, outputs are saved. Otherwise, they
are shown interactively and recorded in-memory.
}
\examples{
ref_fasta <- system.file("extdata", "Ref.fasta", package = "DspikeIn")
sample_fasta <- system.file("extdata", "Sample.fasta", package = "DspikeIn")
result <- validate_spikein_clade(ref_fasta, sample_fasta)

}
