% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_network_robustness.R
\name{simulate_network_robustness}
\alias{simulate_network_robustness}
\title{Simulate Network Robustness under Node Removal}
\usage{
simulate_network_robustness(
  graph,
  steps = 10,
  removal_strategy = "random",
  plot_results = TRUE
)
}
\arguments{
\item{graph}{An \code{igraph} object representing the network.}

\item{steps}{Integer. Number of nodes to remove. Default is \code{10}.}

\item{removal_strategy}{Character. Node removal strategy, one of:
\itemize{
\item \code{"random"} (default): Removes nodes randomly.
\item \code{"degree"}: Removes the highest-degree nodes first.
\item \code{"betweenness"}: Removes the highest-betweenness nodes first.
}}

\item{plot_results}{Logical. If \code{TRUE}, generates and \strong{returns} a plot of the robustness curve. Default is \code{TRUE}.}
}
\value{
A \strong{list} containing:
\itemize{
\item \code{results}: A \code{data.frame} with the step number and the relative size of the largest connected component.
\item \code{plot}: A \code{ggplot2} object (returned if \code{plot_results = TRUE}).
}
}
\description{
Evaluates the robustness of a network by iteratively removing nodes
and measuring the size of the largest connected component at each step.
}
\details{
Users can specify a node removal strategy from the following options:
\itemize{
\item \strong{"random"}: Removes nodes randomly.
\item \strong{"degree"}: Removes the node with the highest degree first.
\item \strong{"betweenness"}: Removes the node with the highest betweenness centrality first.
}

\strong{Important:} For the \code{"betweenness"} strategy, all edge weights \strong{must be positive}.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  Complete <- load_graphml("Complete.graphml")

  # Simulate robustness by removing 200 highest-degree nodes
  robustness_degree <- simulate_network_robustness(
    graph = Complete,
    steps = 200,
    removal_strategy = "degree"
  )

  # Simulate robustness with random node removal
  robustness_random <- simulate_network_robustness(
    graph = Complete,
    steps = 200,
    removal_strategy = "random"
  )

  # Simulate robustness with betweenness-based node removal
  robustness_betweenness <- simulate_network_robustness(
    graph = Complete,
    steps = 200,
    removal_strategy = "betweenness"
  )

  # Print robustness plots
  print(robustness_degree$plot)
  print(robustness_random$plot)
  print(robustness_betweenness$plot)
}
}
