% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ridge_Plot_it.R
\name{ridge_plot_it}
\alias{ridge_plot_it}
\title{Generate Ridge Plots for Taxonomic Abundance Distribution}
\usage{
ridge_plot_it(obj, taxrank = "Genus", rarefaction_depth = NULL, top_n = 10)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object containing taxonomic and abundance data.}

\item{taxrank}{A character string specifying the taxonomic rank for glomming and plotting. Default is "Genus".}

\item{rarefaction_depth}{A numeric value specifying the rarefaction depth. If NULL, it is set to 90\\%
of the minimum sample sum (for \code{phyloseq}). Default is NULL.}

\item{top_n}{An integer specifying the number of top taxa to include in the plot. Default is 10.}
}
\value{
A \code{ggplot2} object representing the ridge plot of the distribution of relative abundances.
}
\description{
This function processes microbiome data (\code{phyloseq} or \code{TreeSummarizedExperiment}),
rarefies the dataset, performs proportion transformation, and generates ridge plots
to visualize the distribution of relative abundances at a specified taxonomic rank.
}
\details{
This function:
\itemize{
\item Rarefies the dataset (if \code{phyloseq}) to normalize sample depth.
\item Extracts abundance and taxonomic data using \code{get_otu_table()} and \code{get_tax_table()}.
\item Aggregates abundance data at the specified taxonomic rank.
\item Selects the top \code{n} taxa by total abundance.
\item Generates a ridge plot to visualize abundance distributions.
}
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  # Load phyloseq object
  data("physeq_16SOTU", package = "DspikeIn")
  ridge_physeq <- ridge_plot_it(physeq_16SOTU, taxrank = "Family", top_n = 10)


  # convert phyloseq object to TSE
  tse_16SOTU <- convert_phyloseq_to_tse(physeq_16SOTU)
  ridge_tse <- ridge_plot_it(tse_16SOTU, taxrank = "Family", top_n = 10)
}

}
