% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spikein_tree_diagnostic.R
\name{plot_spikein_tree_diagnostic}
\alias{plot_spikein_tree_diagnostic}
\title{Spike-in Tree Diagnostic Plot}
\usage{
plot_spikein_tree_diagnostic(
  obj,
  metadata_var,
  output_prefix = "spikein_diag",
  layout = "circular",
  save_plot = FALSE,
  width = 10,
  height = 10
)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object filtered to spike-in taxa.}

\item{metadata_var}{Character. Sample metadata variable to use as tile color.}

\item{output_prefix}{Character. Filename prefix for saved plot. Default = "spikein_diag".}

\item{layout}{Character. Tree layout. Default = "circular".}

\item{save_plot}{Logical. Save figure if TRUE.}

\item{width}{Numeric. Width of the output plot in inches. Default = 10.}

\item{height}{Numeric. Height of the output plot in inches. Default = 10.}
}
\value{
Invisibly returns the ggplot object.
}
\description{
Diagnostic visualization of spike-in taxa (ASVs/OTUs) on a phylogenetic tree.
Works with both \code{phyloseq} and \code{TreeSummarizedExperiment} objects (auto-converts internally).

Visual elements:
\itemize{
\item Tip labels (OTU/ASV names)
\item Branch length annotations
\item Prevalence (star size on tip)
\item Log10(mean abundance) (bar ring)
\item Sample metadata (discrete tile at tip)
}
}
\examples{
\dontrun{
if (
  requireNamespace("DspikeIn", quietly = TRUE) &&
    requireNamespace("phyloseq", quietly = TRUE) &&
    requireNamespace("TreeSummarizedExperiment", quietly = TRUE) &&
    requireNamespace("ggplot2", quietly = TRUE) &&
    requireNamespace("ggtree", quietly = TRUE) &&
    requireNamespace("ggtreeExtra", quietly = TRUE) &&
    requireNamespace("ggstar", quietly = TRUE) &&
    requireNamespace("ggnewscale", quietly = TRUE)
) {
  # ----------- Phyloseq Example -----------
  data("physeq_16SOTU", package = "DspikeIn")
  spikein_ps <- phyloseq::subset_taxa(physeq_16SOTU, Genus == "Tetragenococcus")

  plot_spikein_tree_diagnostic(
    obj = spikein_ps,
    metadata_var = "Animal.type",
    save_plot = FALSE
  )

  # ----------- TSE Example -----------
  tse_spikein <- convert_phyloseq_to_tse(spikein_ps)

  plot_spikein_tree_diagnostic(
    obj = tse_spikein,
    metadata_var = "Animal.type",
    save_plot = FALSE
  )
}
}
}
