% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/physeq_ITSOTU.R
\docType{data}
\name{physeq_ITSOTU}
\alias{physeq_ITSOTU}
\title{Example Phyloseq Object for ITS OTUs}
\format{
A \code{phyloseq} object with:
\describe{
\item{otu_table}{Operational Taxonomic Unit (OTU) abundance matrix.}
\item{tax_table}{Taxonomic classification of OTUs.}
\item{sample_data}{Metadata associated with the samples.}
\item{phy_tree}{Phylogenetic tree relating OTUs (if available).}
}
}
\source{
Internal dataset for microbiome analysis.
}
\usage{
data(physeq_ITSOTU)
}
\value{
A \code{phyloseq} object containing ITS OTU data with taxonomy, sample metadata, and phylogeny.
}
\description{
This dataset contains an example \code{phyloseq} object representing
Internal Transcribed Spacer (ITS) amplicon sequencing data. It includes
taxonomic annotations, OTU abundance counts, and associated sample metadata,
suitable for downstream analysis of fungal communities.
}
\examples{
if (requireNamespace("phyloseq", quietly = TRUE)) {
  data(physeq_ITSOTU)
  physeq_ITSOTU
  summary(physeq_ITSOTU)
  phyloseq::sample_data(physeq_ITSOTU)
  phyloseq::taxa_names(physeq_ITSOTU)
}
}
\keyword{datasets}
