% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my_custom_theme.R
\name{my_custom_theme}
\alias{my_custom_theme}
\title{Custom ggplot2 Theme with Consistent Aesthetics}
\usage{
my_custom_theme(base_size = 12, font_family = "sans", bg_color = "white")
}
\arguments{
\item{base_size}{Numeric. Base font size for text elements (default: 12).}

\item{font_family}{Character. Font family to use for text elements (default: "sans").}

\item{bg_color}{Character. Background color of the plot (default: "white").}
}
\value{
A ggplot2 theme object.
}
\description{
Creates a custom ggplot2 theme with consistent styling options,
including background color, font size, and axis line formatting.
}
\details{
This function applies a custom theme to ggplot2 plots. It removes unnecessary
grid lines, ensures a clean background, and standardizes text styling.
}
\examples{
library(ggplot2)
p <- ggplot(mtcars, aes(x = wt, y = mpg)) +
  geom_point(size = 3) +
  my_custom_theme()
print(p)

}
