% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{label}
\alias{label}
\title{Label Taxonomic Ranks by Hashcode}
\usage{
label(obj, hashcode_label_map, tax_rank = "Species")
}
\arguments{
\item{obj}{A \code{\link[phyloseq:phyloseq]{phyloseq::phyloseq}} object with a populated \code{tax_table()}.}

\item{hashcode_label_map}{A named character vector where names are ASV hashcodes
(i.e., row names of the tax table), and values are the taxonomy labels to assign.}

\item{tax_rank}{A character string specifying the taxonomic rank to label
(e.g., \code{"Species"}, \code{"Genus"}, \code{"Family"}). Default is \code{"Species"}.}
}
\value{
A modified \code{phyloseq} object with updated taxonomic labels at the specified rank.
}
\description{
Labels ASVs/OTUs in a \code{phyloseq} object using a named vector mapping hashcodes
to known taxonomy labels (e.g., spike-in species, genera, or families). This is
especially useful for clearly labeling synthetic controls or mock taxa.

If the specified taxonomic rank (e.g., "Genus" or "Family") does not exist in the
\code{tax_table}, it will be added and filled with \code{NA}, followed by inserting your custom labels.
}
\examples{
if (requireNamespace("phyloseq", quietly = TRUE)) {
  library(phyloseq)

  # Create dummy tax_table with hashcodes
  tax_mat <- matrix(
    data = c(
      "Bacteria", NA,
      "Bacteria", NA,
      "Bacteria", NA,
      "Bacteria", NA
    ),
    nrow = 4,
    dimnames = list(
      c(
        "8ac7ad6e4b6501eb143d97f10bcc2b6d",
        "5a92565231c6df8f58871c0df2d1a12a",
        "8bf5a7b04cb725bc3d2627b971eb03fb",
        "7ae171e44f46ddadcbb53ee6b34a483b"
      ),
      c("Kingdom", "Species")
    )
  )

  ps <- phyloseq::phyloseq(phyloseq::tax_table(tax_mat))

  # Define hash-to-label map
  hash_map <- c(
    "8ac7ad6e4b6501eb143d97f10bcc2b6d" = "MockGenus_A",
    "5a92565231c6df8f58871c0df2d1a12a" = "MockGenus_B"
  )

  # Label genus (automatically adds "Genus" column if missing)
  ps <- label(ps, hash_map, tax_rank = "Genus")

  # Check updated taxonomy
  phyloseq::tax_table(ps)[, "Genus"]
}

}
\seealso{
\code{\link[phyloseq:tax_table-methods]{phyloseq::tax_table()}}
}
