% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_neighbors.R
\name{extract_neighbors}
\alias{extract_neighbors}
\title{Extract First and Second Neighbors of a Target Node}
\usage{
extract_neighbors(graph = NULL, target_node, mode = "all")
}
\arguments{
\item{graph}{Either:
\itemize{
\item An \code{igraph} object representing a network, OR
\item A character string specifying the \strong{file path} to a GraphML file, OR
\item \code{NULL} to use \code{"Complete.graphml"} from \code{DspikeIn}.
}}

\item{target_node}{Character. The \strong{name} of the target node.}

\item{mode}{Character. Direction of edges to consider (\code{"all"}, \code{"out"}, \code{"in"}).
\itemize{
\item \code{"all"}: Incoming + outgoing edges (default for undirected graphs).
\item \code{"out"}: Only outgoing edges.
\item \code{"in"}: Only incoming edges.
}}
}
\value{
A list containing:
\item{first_neighbors}{Character vector of \strong{first-degree} neighbor names.}
\item{second_neighbors}{Character vector of \strong{second-degree} neighbor names.}
\item{summary}{Data frame summarizing the extracted neighbors.}
}
\description{
Extracts the first and second neighbors of a given target node in an \code{igraph} network.
Users can provide either an \code{igraph} object or a GraphML file path (internal or external).
}
\examples{
# Load the built-in Complete graph
complete_graph <- load_graphml("Complete.graphml")
result1 <- extract_neighbors(
  graph = complete_graph,
  target_node = "OTU69:Basidiobolus_sp"
)
print(result1$summary)


# Load from an external GraphML file (ensure the file path is correct)
# external_graph <- load_graphml("~/custom_network.graphml")
# extract_neighbors(external_graph, target_node = "SomeNode")

}
