% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_phyloseq_to_tse.R
\name{convert_phyloseq_to_tse}
\alias{convert_phyloseq_to_tse}
\title{Convert a \code{phyloseq} Object to a \code{TreeSummarizedExperiment}}
\usage{
convert_phyloseq_to_tse(physeq)
}
\arguments{
\item{physeq}{A valid \code{phyloseq} object.}
}
\value{
A \code{TreeSummarizedExperiment} object with one or more of the following slots:
\itemize{
\item \code{assays}: OTU count matrix.
\item \code{rowData}: Taxonomy table.
\item \code{colData}: Sample metadata.
\item \code{rowTree}: Phylogenetic tree (if present).
\item \code{referenceSeq}: Reference sequences (if present).
}
}
\description{
Converts a \code{phyloseq} object into a \code{TreeSummarizedExperiment} (TSE),
preserving key biological data components. The function supports retention of:
\itemize{
\item OTU abundance matrix (as assay).
\item Taxonomic classifications (as \code{rowData}).
\item Sample metadata (as \code{colData}).
\item Phylogenetic tree (as \code{rowTree}, if available).
\item Reference sequences (as \code{referenceSeq}, if available).
}
This allows seamless interoperability between \code{phyloseq} and Bioconductor ecosystems.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("physeq_16SOTU", package = "DspikeIn")

  # Create a small subset for fast execution
  physeq_sub <- phyloseq::prune_taxa(
    phyloseq::taxa_names(physeq_16SOTU)[1:10],
    phyloseq::prune_samples(
      phyloseq::sample_names(physeq_16SOTU)[1:5],
      physeq_16SOTU
    )
  )

  # Example transformation
  tse_sub <- convert_phyloseq_to_tse(physeq_sub)
  tse_sub
}

}
