% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjusted_prevalence.R
\name{adjusted_prevalence}
\alias{adjusted_prevalence}
\title{Adjust Prevalence in a Microbiome Object}
\usage{
adjusted_prevalence(obj, method = "min", output_file = NULL)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object.}

\item{method}{Character. Threshold method: one of \code{"min"}, \code{"mean"}, \code{"median"}, or \code{"max"}.}

\item{output_file}{Optional. Character. Path to save the adjusted object as \code{.rds}.
Default is \code{NULL}, meaning no file will be saved unless explicitly provided.}
}
\value{
The adjusted object of the same class as \code{obj}.
}
\description{
Removes low-prevalence taxa from a \code{phyloseq} or \code{TreeSummarizedExperiment} object based
on user-specified prevalence thresholds derived from taxa abundance statistics.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("physeq_16SOTU", package = "DspikeIn")

  ## Adjust prevalence in phyloseq
  adjusted_physeq <- adjusted_prevalence(physeq_16SOTU, method = "mean")

  ## Convert to TreeSummarizedExperiment
  tse_obj <- convert_phyloseq_to_tse(physeq_16SOTU)

  ## Adjust prevalence in TSE
  adjusted_tse <- adjusted_prevalence(tse_obj, method = "median")
}

}
