% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_abundance_by_factor.R
\name{adjust_abundance_one_third}
\alias{adjust_abundance_one_third}
\alias{adjust_abundance_by_factor}
\title{Adjust Abundance by a Custom Factor}
\usage{
adjust_abundance_one_third(obj, factor = 3, output_file = NULL)

adjust_abundance_by_factor(obj, factor = 3, output_file = NULL)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object containing microbiome count data.}

\item{factor}{A numeric value \eqn{> 0} specifying the divisor applied to abundance counts.
Default is 3 (historically used as the one-third normalization factor).}

\item{output_file}{A character string specifying a path to save the adjusted object as \code{.rds}.
Default is \code{NULL} (no file written).}
}
\value{
An adjusted object of the same class (\code{phyloseq} or \code{TreeSummarizedExperiment}),
where the abundance values are divided by the specified \code{factor}.
}
\description{
This function normalizes microbial abundance data in a \code{phyloseq} or \code{TreeSummarizedExperiment}
object by dividing all abundance values by a user-defined factor.
It supports both data structures and preserves their internal metadata.
}
\details{
This function extracts the OTU table (for \code{phyloseq}) or assay matrix (for \code{TSE}),
divides all abundance values by the provided \code{factor}, and reinserts the adjusted
table while maintaining the full metadata structure.

Historically, the function name \code{adjust_abundance_one_third()} referred to a fixed
normalization by 3. This generalized version preserves the same function name for
backward compatibility and allows any user-defined divisor.

For clarity, an alias function \code{adjust_abundance_by_factor()} is provided.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("physeq_16SOTU", package = "DspikeIn")

  # Adjust phyloseq object
  adjusted_physeq <- adjust_abundance_one_third(physeq_16SOTU, factor = 3)

  # Convert to TSE and adjust
  tse_16SOTU <- convert_phyloseq_to_tse(physeq_16SOTU)
  adjusted_tse <- adjust_abundance_one_third(tse_16SOTU, factor = 2)

  # Using the alias
  adjusted_physeq2 <- adjust_abundance_by_factor(physeq_16SOTU, factor = 5)
}

}
\seealso{
\code{\link{convert_phyloseq_to_tse}}
}
