% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pre_processing_species_list.R
\name{Pre_processing_species_list}
\alias{Pre_processing_species_list}
\title{Preprocess and Merge Spike-in Species in a Phyloseq or TSE Object}
\usage{
Pre_processing_species_list(
  obj,
  spiked_species,
  merge_method = c("sum", "max"),
  output_file = NULL
)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object.}

\item{spiked_species}{Character vector of species names to be processed (matched against the \code{Species} column in taxonomy).}

\item{merge_method}{Either \code{"sum"} (default) to sum counts across ASVs or \code{"max"} to retain only the most abundant ASV.}

\item{output_file}{Optional. File path to save the merged object as an \code{.rds} file.}
}
\value{
A merged object of the same class as the input (\code{phyloseq} or \code{TreeSummarizedExperiment}).
}
\description{
Merges ASVs belonging to user-defined spike-in species by summing or selecting maximum counts,
while preserving all available metadata (taxonomy, sample data, phylogenetic tree, and reference sequences).
This function works for both \code{phyloseq} and \code{TreeSummarizedExperiment} objects.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("physeq", package = "DspikeIn")
  data("tse", package = "DspikeIn")

  spiked_species <- c("Pseudomonas aeruginosa", "Escherichia coli", "Clostridium difficile")

  # Merge in phyloseq object
  merged_physeq <- Pre_processing_species_list(
    physeq,
    spiked_species = spiked_species,
    merge_method = "sum"
  )

  # Merge in TreeSummarizedExperiment object
  merged_tse <- Pre_processing_species_list(
    tse,
    spiked_species = spiked_species,
    merge_method = "sum"
  )
}

}
