% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AcceptableRange.R
\docType{data}
\name{AcceptableRange}
\alias{AcceptableRange}
\title{Acceptable Range Data}
\format{
A data frame with the following columns:
\describe{
\item{Ecoregion_III}{EPA Level III ecoregion classification.}
\item{Genus}{Genus of the taxon.}
\item{Host_genus}{Host genus from which the sample was derived.}
\item{Percentage}{Observed spike-in percentage.}
\item{Phylum}{Phylum classification of the taxon.}
\item{Range}{Acceptable range category.}
\item{Total_Reads_spiked}{Number of reads matching the spike-in species.}
\item{Total_Reads_total}{Total number of reads per sample.}
\item{X}{Row identifier (optional, may be an index or artifact of data processing).}
\item{mean_abundance}{Mean abundance across all samples.}
}
}
\source{
Internal package dataset.
}
\usage{
data(AcceptableRange)
}
\value{
A data frame of spike-in evaluation metrics and taxonomy annotations.
}
\description{
This dataset provides reference ranges and sample-level metadata for microbial
spike-in performance evaluation. It includes taxonomic annotations and summary
statistics used in validation and quality control workflows.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("AcceptableRange", package = "DspikeIn")
  head(AcceptableRange)
  summary(AcceptableRange$Percentage)
}
}
\keyword{datasets}
