% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vennplot.R
\name{vennplot}
\alias{vennplot}
\title{vennplot}
\usage{
vennplot(Sets, by = "gplots", ...)
}
\arguments{
\item{Sets}{a list of object, can be vector or GRanges object}

\item{by}{one of gplots, ggVennDiagram or Vennerable}

\item{...}{extra parameters using ggVennDiagram. Details see \link[ggVennDiagram]{ggVennDiagram}}
}
\value{
venn plot that summarize the overlap of peaks
from different experiments or gene annotation from
different peak files.
}
\description{
plot the overlap of a list of object
}
\details{
There are two ways to plot, which users can specify through `by`.

The first way is to use `gplots` packages, by setting `by = gplots`. This method
is default method. The venn plot produced through this way has no color.

The second way is to use `ggVennDiagram` packages, by setting `by = ggVennDiagram`. 
The venn plot produced through this way has colors which can be defined by users using
ggplot2 grammar e.g.(scale_fill_distiller()). And users can specify any details, like digital number,
text size and showing percentage or not, by inputting `...` extra parameters.
}
\examples{
## example not run
## require(TxDb.Hsapiens.UCSC.hg19.knownGene)
## txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
## peakfiles <- getSampleFiles()
## peakAnnoList <- lapply(peakfiles, annotatePeak)
## names(peakAnnoList) <- names(peakfiles)
## genes= lapply(peakAnnoList, function(i) as.data.frame(i)$geneId)
## vennplot(genes)
}
\author{
G Yu
}
