% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleLigandReceptorAnalysis.R
\name{makeLRInteractionHeatmap}
\alias{makeLRInteractionHeatmap}
\title{This function takes ligandReceptorResults and plots a heatmap of -log10(pvalues).
If the minimum p-value is 0 a pseudocount of 0.001 will be added before log
transformation.}
\usage{
makeLRInteractionHeatmap(
  ligandReceptorResults,
  clusters,
  colours = c(),
  pValCutoffClusterPair = 0.05,
  pValCutoffLigRec = 0.05,
  labelClusterPairs = TRUE
)
}
\arguments{
\item{ligandReceptorResults}{\itemize{
\item as returned by performLigandReceptorAnalysis()
}}

\item{clusters}{\itemize{
\item named vector of cell types where names are each cell and
clusters are a factor
}}

\item{colours}{\itemize{
\item a named list of colours where names are clusters. If not
specified the default pheatmap colour scheme will be used.
}}

\item{pValCutoffClusterPair}{\itemize{
\item a cutoff for showing interactions between two
clusters. A cluster pair must have at least one ligand-receptor interaction
pvalue <  pValCutoffClusterPair. Defaults to 0.05.
}}

\item{pValCutoffLigRec}{\itemize{
\item a cutoff for showing interactions between a
ligand and receptor. At least one cluster pair must have
pvalue <  pValCutoffLigRec for ligand-receptor pair. Defaults to 0.05.
}}

\item{labelClusterPairs}{\itemize{
\item show labels for cluster pairs. Defaults to TRUE.
}}
}
\value{
matrix of -log10(pvalues) that underlies the heatmap.
}
\description{
This function takes ligandReceptorResults and plots a heatmap of -log10(pvalues).
If the minimum p-value is 0 a pseudocount of 0.001 will be added before log
transformation.
}
\examples{
getExample = make.getExample()
clusters = getExample('clusters')
ligandReceptorResults = getExample('ligandReceptorResults')
cellTypePerCellTypeLigRecMatrix = 
makeSummedLRInteractionHeatmap(ligandReceptorResults, clusters, "mean")
}
