% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGenesVsCells.R
\name{getGeneClusterAveragesPerCell}
\alias{getGeneClusterAveragesPerCell}
\title{This produces a matrix giving the average expression of gene
clusters in cells.  By default, it uses all cells and all gene
clusters.}
\usage{
getGeneClusterAveragesPerCell(
  f,
  fPrime,
  cells = colnames(f),
  geneClusters = getClusterOrder(fPrime),
  layer = "data"
)
}
\arguments{
\item{f}{\itemize{
\item the cell Seurat object or SingleCellExperiment to be
turned into a Seurat object
}}

\item{fPrime}{\itemize{
\item the genes Seurat object or SingleCellExperiment to be
turned into a Seurat object
}}

\item{cells}{\itemize{
\item the cells to compute this for
}}

\item{geneClusters}{\itemize{
\item the geneClusters to compute average
expression for
}}

\item{layer}{\itemize{
\item the data layer to use, defaults to 'data'
}}
}
\value{
A matrix where the rows correspond to cells, the columns
correspond to geneClusters and the entries give average expression
for each cluster in each cell
}
\description{
This produces a matrix giving the average expression of gene
clusters in cells.  By default, it uses all cells and all gene
clusters.
}
\examples{
getExample = make.getExample()
exSeuratObj = getExample('exSeuratObj',toy=TRUE)
STranspose = getExample('STranspose',toy=TRUE)
clusterExpression = getGeneClusterAveragesPerCell(exSeuratObj,STranspose)
}
