% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleNeighbourhoods.R
\name{getExtendedNBHDs}
\alias{getExtendedNBHDs}
\title{This function takes a nearest neighbour graph and a radius
and calculates nth degree neighbour graphs where max(n) == radius}
\usage{
getExtendedNBHDs(spatialGraph, n)
}
\arguments{
\item{spatialGraph}{\itemize{
\item a nearest neighbour graph
}}

\item{n}{\itemize{
\item the maximum degree to calculate a neighbour graph with edges
connecting vertices of degree n for.
}}
}
\value{
A named list of neighbour graphs, where each graph contains edges
connecting vertices of degree n. Each graph is named according to degree n.
}
\description{
This function takes a nearest neighbour graph and a radius
and calculates nth degree neighbour graphs where max(n) == radius
}
\examples{
delaunayNeighbours = make.getExample()('delaunayNeighbours')
extendedNeighboursList = getExtendedNBHDs(delaunayNeighbours, 4)
}
