% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleEdgeQualityControl.R
\name{edgeCutoffsByPercentile}
\alias{edgeCutoffsByPercentile}
\title{This finds edge cutoffs by percentile}
\usage{
edgeCutoffsByPercentile(annEdges, percentileCutoff)
}
\arguments{
\item{annEdges}{\itemize{
\item a data frame with columns nodeA, nodeB, length
and cellTypePair as produced by edgeLengthsAndCellTypePairs.
}}

\item{percentileCutoff}{\itemize{
\item a numeric
}}
}
\value{
This returns a data frame with columns cellTypePair and
cutoff.
}
\description{
This finds edge cutoffs by percentile
}
\examples{
getExample = make.getExample()
centroids = getExample('centroids')
clusters = getExample('clusters')
delaunayNeighbours = getExample('delaunayNeighbours')
annEdges =
    edgeLengthsAndCellTypePairs(delaunayNeighbours,clusters,centroids)
cutoffDF = edgeCutoffsByPercentile(annEdges,percentileCutoff=95)
}
