% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGeneAnnotation.R
\name{combinatorialSpheres}
\alias{combinatorialSpheres}
\title{Discovers the combinatorial ball of a given radius
around a fixed set of genes in the nearest neighbor
graph of a Seurat object.}
\usage{
combinatorialSpheres(NN, origin, radius)
}
\arguments{
\item{NN}{\itemize{
\item a nearest neighbors graph
}}

\item{origin}{\itemize{
\item a gene or list of genes
}}

\item{radius}{\itemize{
\item the radius of the combinatorial ball
to be found.
}}
}
\value{
This returns a data frame whose columns are the
gene name, the radius from the origin at which it is found
}
\description{
Discovers the combinatorial ball of a given radius
around a fixed set of genes in the nearest neighbor
graph of a Seurat object.
}
\examples{
getExample = make.getExample()
NN = getExample('NN',toy=TRUE)
STranspose = getExample('STranspose',toy=TRUE)
spheres = combinatorialSpheres(NN,'Ccl6',3)
hallmark = getExample('hallmark')
geneSet = intersect(hallmark[["HALLMARK_TNFA_SIGNALING_VIA_NFKB"]],colnames(STranspose))
sphereAroundSet = combinatorialSpheres(NN,geneSet,1)
}
