% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleNeighbourhoods.R
\name{collapseExtendedNBHDs}
\alias{collapseExtendedNBHDs}
\title{This function takes an expanded neighbourhood list and collapses it to a
nearest neighbourhood graph where all neighbours of degree <= n in the
original graph are considered first neighbours.}
\usage{
collapseExtendedNBHDs(
  extendedNeighboursList,
  n = length(extendedNeighboursList)
)
}
\arguments{
\item{extendedNeighboursList}{\itemize{
\item the results of getExtendedNBHDs()
}}

\item{n}{\itemize{
\item the maximum degree to connect neighbours. Defaults to the maximum
degree neighbourhoods were expanded to in the results of getExtendedNBHDs().
}}
}
\value{
a graph in neighbour format, i.e., a data frame with
columns nodeA and nodeB, where nodes that were originally of degree <= n
are connected.
}
\description{
This function takes an expanded neighbourhood list and collapses it to a
nearest neighbourhood graph where all neighbours of degree <= n in the
original graph are considered first neighbours.
}
\examples{
extendedNeighboursList = make.getExample()('extendedNeighboursList',toy=TRUE)
extendedNeighbours = collapseExtendedNBHDs(extendedNeighboursList, 4)
}
