% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcbn.R
\name{hcbnSingle}
\alias{hcbnSingle}
\title{H-CBN Single Batch}
\usage{
hcbnSingle(
  datasetObj,
  anneal = FALSE,
  temp = 0,
  annealingSteps = 0,
  epsilon = 2
)
}
\arguments{
\item{datasetObj}{\code{Spock} object with poset and pattern/lambda data.}

\item{anneal}{If \code{TRUE}, performes a simulated annealing run starting from the poset}

\item{temp}{Temperature of simulated annealing.}

\item{annealingSteps}{Number of simulated annealing steps.}

\item{epsilon}{Value of eps for CT-CBN model selection. Requires both pattern and lambda data in input \code{Spock}.}
}
\value{
A list of output data.
}
\description{
H-CBN Single Batch
}
\examples{
examplePath <- getExamples()[1]
bc <- Spock$new(
    poset = readPoset(examplePath)$sets,
    numMutations = readPoset(examplePath)$mutations,
    genotypeMatrix = readPattern(examplePath)
)
hcbnSingle(bc)
}
