% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{.checkReceptorSignaling}
\alias{.checkReceptorSignaling}
\title{Internal function to check receptor signaling downstream}
\usage{
.checkReceptorSignaling(
  ds,
  lr,
  reference = c("REACTOME-GOBP", "REACTOME", "GOBP"),
  max.pw.size = 400,
  min.pw.size = 5,
  min.positive = 4,
  use.full.network = FALSE,
  restrict.pw = NULL,
  with.complex = TRUE
)
}
\arguments{
\item{ds}{A BSRDataModel object.}

\item{lr}{A table as returned by \code{.getCorrelatedLR()}.}

\item{reference}{Which pathway reference should be used ("REACTOME"
for Reactome, "GOBP" for GO Biological Process,
or "REACTOME-GOBP" for both).}

\item{max.pw.size}{Maximum pathway size to consider from the pathway
reference.}

\item{min.pw.size}{Minimum pathway size to consider from the pathway
reference.}

\item{min.positive}{Minimum number of target genes to be found in a given
pathway.}

\item{use.full.network}{A logical to avoid limiting the reference network
to the detected genes and use the whole reference network.}

\item{restrict.pw}{A list of pathway IDs to restrict the application of
the function.}

\item{with.complex}{A logical indicating whether receptor co-complex
members should be included in the target genes.}
}
\value{
A data frame extending \code{lr} content with the pathways found to
contain the receptors and data about target gene correlations with those
receptors. Strings in semi-colon-separated format are used to report
target genes and their Spearman correlations with the receptor in the
data frame. The target genes are sorted according to the correlation
coefficient.

In a pathway of the reference, i.e., a Reactome pathway or the genes of a
GOBP term, the target genes are the
genes coding for proteins forming a complex with the receptor and the
genes in the pathway downstream the receptor,
which are given as regulated by the pathway. If \code{with.complex} is
set to \code{FALSE}, then only the
regulated genes are considered. Participation to a complex and being
regulated as well as the pathway directed topologies
are defined by Reactome and KEGG pathways as provided by PathwayCommons.

The maximum pathway size is used to limit the redundancy inherent to GOBP
and Reactome. The minimum pathway size is
used to avoid overspecific, noninformative results.
}
\description{
Assess the existence of correlations between a receptor,
part of a ligand-receptor pair, and
genes coding for proteins forming a complex with the receptor or genes
regulated by the receptor downstream signaling.
}
\keyword{internal}
