% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSRInferenceComp-class.R
\name{BSRInferenceComp}
\alias{BSRInferenceComp}
\title{Inference of ligand-receptor interactions based on regulation}
\usage{
BSRInferenceComp(
  obj,
  cmp.name,
  src.cmp.name = NULL,
  rank.p = 0.55,
  max.pval = 0.01,
  min.logFC = 1,
  neg.receptors = FALSE,
  pos.targets = FALSE,
  neg.targets = FALSE,
  min.t.logFC = 0.5,
  restrict.genes = NULL,
  use.full.network = FALSE,
  reference = c("REACTOME-GOBP", "REACTOME", "GOBP"),
  max.pw.size = 400,
  min.pw.size = 5,
  min.positive = 2,
  restrict.pw = NULL,
  with.complex = TRUE,
  fdr.proc = c("BH", "Bonferroni", "Holm", "Hochberg", "SidakSS", "SidakSD", "BY", "ABH",
    "TSBH")
)
}
\arguments{
\item{obj}{A BSRDataModelComp object.}

\item{cmp.name}{The name of the cluster comparison that should be used
for the inference. Autocrine interactions if only this comparison name is
provided, paracrine if a source comparison name is provided as well.}

\item{src.cmp.name}{The name of the source cluster comparison that should
be used for paracrine interaction inferences.}

\item{rank.p}{A number between 0 and 1 defining the rank of the last
considered target genes.}

\item{max.pval}{The maximum P-value imposed to both the ligand
and the receptor.}

\item{min.logFC}{The minimum log2 fold-change allowed for
both the receptor and the ligand.}

\item{neg.receptors}{A logical indicating whether receptors are only
allowed to be upregulated (FALSE), or up- and downregulated (TRUE).}

\item{pos.targets}{A logical imposing that all the network targets must
display positive logFC, i.e. logFC >= min.t.logFC.}

\item{neg.targets}{A logical imposing that all the network targets must
display negative logFC, i.e. logFC <= - min.t.logFC.}

\item{min.t.logFC}{The minimum log2 fold-change allowed for
targets in case pos.targets or neg.targets are used.}

\item{restrict.genes}{A list of gene symbols that restricts ligands and
receptors.}

\item{use.full.network}{A logical to avoid limiting the reference network
to the detected genes and use the whole reference network.}

\item{reference}{Which pathway reference should be used ("REACTOME"
for Reactome, "GOBP" for GO Biological Process,
or "REACTOME-GOBP" for both).}

\item{max.pw.size}{Maximum pathway size to consider from the pathway
reference.}

\item{min.pw.size}{Minimum pathway size to consider from the pathway
reference.}

\item{min.positive}{Minimum number of target genes to be found in a given
pathway.}

\item{restrict.pw}{A list of pathway IDs to restrict the application of
the function.}

\item{with.complex}{A logical indicating whether receptor co-complex
members should be included in the target genes.}

\item{fdr.proc}{The procedure for adjusting P-values according to
\code{\link[multtest]{mt.rawp2adjp}}.}
}
\value{
A BSRInferenceComp object with initial inferences set.
}
\description{
This method supports two configurations that we refer to
as paracrine and autocrine.
}
\details{
In the autocrine case, a single cluster comparison name is provided.
In the corresponding cluster comparison, a group of samples A was
compared to a group of samples B to determine fold-changes and associated
P-values. The inferred ligand-receptor interactions take place in the
samples of group A. A typical single-cell example would be a population of
macrophages (group A) compared to all the other populations (group B) to
represent specific increased or decreased expression in macrophages. The
resulting ligand-receptor interactions will be autocrine interactions
that are exacerbated (or reduced depending on the chosen parameters) in
macrophages.

In the paracrine case, two cluster comparison names must be provided.
For instance, a first comparison could involve macrophages versus all
the other cell populations as above. The second comparison could be
B-cells against all the other populations. Now, calling
\code{BSRInferenceComp()}
with comparison macrophages *versus* the rest and, as source comparison,
B-cells *versus* the rest, will result in inferring interactions between
B-cells (ligands) and macrophages (receptors and downstream pathways). To
obtain macrophages to B-cells paracrine interactions, it is necessary to call
the method a second time with permuted cluster comparison names. Another
example in spatial transcriptomics could be two thin bands at the boundary of
two tissue regions, one emitting the ligand and the other one expressing the
receptor.

In this initial inference, all the receptor-containing pathways are reported,
see reduction functions to reduce this list.

Perform the initial ligand-receptor inference. Initial means that
no reduction is applied. All the (ligand, receptor, downstream pathway)
triples are reported, i.e., a given LR pair may appear multiple times
with different pathways downstream the receptor. Specific reduction
functions are available from the package to operate subsequent
simplifications based on the BSRInferenceComp object created by this method.

Here, ligand-receptor interactions are inferred based on gene or protein
regulation-associated P-values when comparing two clusters of samples. Since
a BSRDataModelComp object can contain several such comparisons, the name
of the comparison to use must be specified (parameter \code{cmp.name}).

Note that since the introduction of the use.full.network parameter
(April 29, 2024), the pathway sizes are always computed before potential
intersection with the observed data (use.full.network set to FALSE) for
consistency. Accordingly, the minimum and maximum pathway default values
have been raised from 5 & 200 to 5 & 400 respectively. By default,
use.full.network is set to FALSE.

In addition to statistical significance estimated according to BulkSignalR
statistical model, we compute SingleCellSignalR original LR-score,
based on L and R cluster average expression. 
In the paracrine case, L average expression
is taken from the source cluster.
}
\examples{
data(bsrdm.comp, package = "BulkSignalR")
data(immune.signatures, package = "BulkSignalR")

# infer ligand-receptor interactions from the comparison
bsrinf.comp <- BSRInferenceComp(bsrdm.comp, max.pval = 1, 
reference="REACTOME",
"random.example")

}
