% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vignetteTools.R
\name{getBiocVignette}
\alias{getBiocVignette}
\title{Download a Bioconductor vignette}
\usage{
getBiocVignette(
  vignettePath,
  destfile = tempfile(),
  version = BiocManager::version()
)
}
\arguments{
\item{vignettePath}{\code{character(1)} the additional path information to get to the vignette}

\item{destfile}{\code{character(1)} the file location to store the vignette}

\item{version}{\code{character(1)} such as "3.7", defaults to user version}
}
\value{
\code{character(1)} The filename of the downloaded vignette
}
\description{
The actual vignette path is available using \code{\link[=biocPkgList]{biocPkgList()}}.
}
\examples{
x = biocPkgList()
tmp = getBiocVignette(x$vignettes[[1]][1])
tmp

\dontrun{
library(pdftools)
y = pdf_text(tmp)
y = paste(y,collapse=" ")
library(tm)
v = VCorpus(VectorSource(y))

v <- v |>
    tm_map(stripWhitespace) |>
    tm_map(content_transformer(tolower)) |>
    tm_map(removeWords, stopwords("english")) |>
    tm_map(stemDocument)
dtm = DocumentTermMatrix(v)
inspect(DocumentTermMatrix(v,
    list(dictionary = as.character(x$Package))))
}
}
