% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classDependencies.R
\name{class-dependencies}
\alias{class-dependencies}
\alias{buildClassDepGraph}
\alias{buildClassDepData}
\alias{buildClassDepFromPackage}
\alias{plotClassDep}
\alias{plotClassDepData}
\alias{plotClassDepGraph}
\title{Retrieve Class relationships}
\usage{
buildClassDepGraph(class, includeUnions = FALSE)

buildClassDepData(class, includeUnions = FALSE)

buildClassDepFromPackage(pkg, includeUnions = FALSE)

plotClassDep(class, includeUnions = FALSE)

plotClassDepData(data)

plotClassDepGraph(g)
}
\arguments{
\item{class}{a single \code{character} value defining a \sQuote{S4} class
name}

\item{includeUnions}{\code{TRUE} or \code{FALSE}: Should union definitions
included in the result? (default: \code{FALSE})}

\item{pkg}{a single \code{character} value defining a package name}

\item{data}{a \code{data.frame} with compatible columns. See output of
\code{buildClassDepData}}

\item{g}{an \code{igraph} object with compatible edge attributes. See output
of \code{buildClassDepGraph}}
}
\description{
As the title says it should do something with class relationships
}
\examples{
library("SummarizedExperiment")
depData <- buildClassDepData("RangedSummarizedExperiment")
depData
g <- buildClassDepGraph("RangedSummarizedExperiment")
plotClassDepGraph(g)
}
