% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diseasePairs.R
\name{prepareGDA}
\alias{prepareGDA}
\title{Function to return vertex annotation from a graph in the Vertex Annotation
form and format it for further analysis.}
\usage{
prepareGDA(gg, name)
}
\arguments{
\item{gg}{igraph object to take annotation from}

\item{name}{name of the vertex attribute that contains annotation. If graph
has no such vertex attribute an error is thrown..}
}
\value{
escaped annotation in Vertex Annotation form
}
\description{
Function to return vertex annotation from a graph in the Vertex Annotation
form and format it for further analysis.
}
\examples{
file <- system.file("extdata", "PPI_Presynaptic.gml", package = "BioNAR")
gg <- igraph::read_graph(file, format="gml")
agg<-annotateGeneNames(gg)
# due to error in org.Hs.eg.db we have to manually check annotation of one node
idx <- which(V(agg)$name == '80273')
paste(V(agg)$GeneName[idx], 'GRPEL1')
gda<-prepareGDA(agg, 'TopOntoOVGHDOID')
gda<-prepareGDA(agg, 'TopOntoOVGHDOID')
head(gda)
}
\seealso{
getAnnotationVertexList

escapeAnnotation
}
