% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{BIOCARTA_PATHWAYS}
\alias{BIOCARTA_PATHWAYS}
\alias{PATHWAY2BC}
\alias{PATHWAY2ENTREZ}
\alias{PATHWAY2MSIGDB}
\alias{BC2ENTREZ}
\title{Pre-computed data objects}
\format{
An object of class \code{list} of length 314.

An object of class \code{data.frame} with 4428 rows and 2 columns.

An object of class \code{data.frame} with 5196 rows and 2 columns.

An object of class \code{data.frame} with 292 rows and 2 columns.

An object of class \code{data.frame} with 1739 rows and 2 columns.
}
\usage{
BIOCARTA_PATHWAYS

PATHWAY2BC

PATHWAY2ENTREZ

PATHWAY2MSIGDB

BC2ENTREZ
}
\value{
\itemize{
\item \code{BIOCARTA_PATHWAYS}: A list of pathway objects. The pathway object is explained in \code{\link[=get_pathway]{get_pathway()}}.
\item \code{PATHWAY2BC}: A two-column data frame of pathway IDs and BC IDs.
\item \code{PATHWAY2ENTREZ}: A two-column data frame of pathway IDs and gene Entrez IDs.
\item \code{PATHWAY2MSIGDB}: A two-column data frame of pathway IDs and MSigDB IDs.
\item \code{BC2ENTREZ}: A two-column data frame of BC IDs and gene EntreZ IDs.
}

The nodes in the original BioCarta pathways are proteins and some of them do not have one-to-one
mapping to genes, such as protein families or complex. Here \code{BC_ID} is the primary ID of proteins/single nodes
in BioCarta Pathways and this package provides mapping to gene EntreZ IDs.
}
\description{
Pre-computed data objects
}
\details{
\code{BIOCARTA_PATHWAYS}, \code{PATHWAY2BC}, \code{PATHWAY2ENTREZ} and \code{BC2ENTREZ} are collected from
web.archive.org (\url{https://web.archive.org/web/20170122225118/https://cgap.nci.nih.gov/Pathways/BioCarta_Pathways}).
\code{PATHWAY2MSIGDB} is collected from MSigDB database (\url{https://www.gsea-msigdb.org/gsea/msigdb/human/genesets.jsp?collection=CP:BIOCARTA}).
The script for generating these datasets can be found at:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{system.file("script", "process.R", package = "BioCartaImage")
}\if{html}{\out{</div>}}
}
\keyword{datasets}
